package ru.yandex.parser.string;

public class NotLessIntegerValidator extends Validator<Integer> {
    private final int min;

    public NotLessIntegerValidator(final int min) {
        super(IntegerParser.INSTANCE);
        this.min = min;
    }

    @Override
    public void validate(final Integer value) throws Exception {
        if (value < min) {
            throw new IllegalArgumentException("Value must be not less than "
                + min);
        }
    }
}

