package ru.yandex.parser.string;

import ru.yandex.function.GenericUnaryOperator;

public class NotLessValidator<T extends Number>
    implements GenericUnaryOperator<T, Exception>
{
    private final T min;

    public NotLessValidator(final T min) {
        this.min = min;
    }

    @Override
    public T apply(final T number) {
        if (number.doubleValue() < min.doubleValue()) {
            throw new IllegalArgumentException("Value must be not less than "
                + min);
        }
        return number;
    }
}

