package ru.yandex.parser.string;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import ru.yandex.function.GenericFunction;

public enum PatternGroupsExtractor
    implements GenericFunction<Pattern, Set<String>, RuntimeException>
{
    INSTANCE;

    private static final Pattern PATTERN = Pattern.compile("<\\p{Alnum}+>");

    @Override
    public Set<String> apply(final Pattern pattern) {
        Matcher matcher = PATTERN.matcher(pattern.toString());
        if (matcher.find()) {
            Set<String> groups = new HashSet<>();
            do {
                String group = matcher.group();
                groups.add(group.substring(1, group.length() - 1));
            } while (matcher.find());
            return groups;
        } else {
            return Collections.emptySet();
        }
    }
}

