package ru.yandex.parser.string;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

import ru.yandex.function.GenericFunction;
import ru.yandex.function.GenericUnaryOperator;

public enum PatternValidator
    implements GenericUnaryOperator<String, Exception>
{
    INSTANCE;

    public static final GenericFunction<String, String, Exception> TRIMMED =
        INSTANCE.compose(String::trim);

    @Override
    public String apply(final String value) throws Exception {
//      allow empty string
//        if (value.isEmpty()) {
//            throw new IllegalArgumentException("Value must be non-empty");
//        }
        // waiting exception here
        try {
           Pattern.compile(value);
        } catch (PatternSyntaxException exception) {
            throw new IllegalArgumentException("Invalid regexp pattern:" + value + exception.getMessage());
        }
        return value;
    }
}

