package ru.yandex.parser.string;

public class PositiveIntegerValidator extends Validator<Integer> {
    public static final PositiveIntegerValidator INSTANCE =
        new PositiveIntegerValidator();

    protected PositiveIntegerValidator() {
        super(IntegerParser.INSTANCE);
    }

    @Override
    public void validate(final Integer value) throws Exception {
        if (value <= 0) {
            throw new IllegalArgumentException("Value must be positive");
        }
    }
}

