package ru.yandex.parser.string;

public class PositiveLongValidator extends Validator<Long> {
    public static final PositiveLongValidator INSTANCE =
        new PositiveLongValidator(LongParser.INSTANCE);

    public PositiveLongValidator(final Parser<Long> parser) {
        super(parser);
    }

    @Override
    public void validate(final Long value) throws Exception {
        if (value <= 0L) {
            throw new IllegalArgumentException("Value must be positive");
        }
    }
}

