package ru.yandex.parser.string;

import ru.yandex.function.GenericUnaryOperator;

public enum PositiveValidator
    implements GenericUnaryOperator<Number, Exception>
{
    INSTANCE;

    @Override
    public Number apply(final Number number) {
        if (number.doubleValue() <= 0d) {
            throw new IllegalArgumentException("Value must be positive");
        }
        return number;
    }

    @SuppressWarnings("unchecked")
    public static <T extends Number, E extends Exception>
        GenericUnaryOperator<T, E> instance()
    {
        return (GenericUnaryOperator<T, E>) INSTANCE;
    }
}

