package ru.yandex.parser.string;

import ru.yandex.function.CharArrayProcessor;
import ru.yandex.function.GenericBiConsumer;
import ru.yandex.function.GenericCollector;
import ru.yandex.function.GenericFunction;

public class SplittingParser<C, R, E extends Exception>
    implements GenericFunction<String, R, E>, CharArrayProcessor<R, E>
{
    private final GenericCollector<
        ? super StringBuilder,
        C,
        ? extends R,
        ? extends E>
        collector;
    private final char delimiter;

    public SplittingParser(
        final GenericCollector<
            ? super StringBuilder,
            C,
            ? extends R,
            ? extends E>
            collector,
        final char delimiter)
    {
        this.collector = collector;
        this.delimiter = delimiter;
    }

    @Override
    public R apply(final String value) throws E {
        return process(value.toCharArray());
    }

    @Override
    public R process(final char[] buf, final int off, final int len)
        throws E
    {
        C collection = collector.supplier().get();
        GenericBiConsumer<? super C, ? super StringBuilder, ? extends E>
            accumulator = collector.accumulator();
        StringBuilder sb = new StringBuilder(len);
        boolean escaped = false;
        for (int i = 0; i < len; ++i) {
            char c = buf[i + off];
            if (escaped) {
                if (c == '\\' || c == delimiter) {
                    sb.append(c);
                } else {
                    sb.append('\\');
                    sb.append(c);
                }
                escaped = false;
            } else if (c == '\\') {
                escaped = true;
            } else if (c == delimiter) {
                accumulator.accept(collection, sb);
                sb.setLength(0);
            } else {
                sb.append(c);
            }
        }
        if (escaped) {
            sb.append('\\');
        }
        accumulator.accept(collection, sb);
        return collector.finisher().apply(collection);
    }

    public GenericCollector<? super StringBuilder, C, ? extends R, ? extends E> collector() {
        return collector;
    }

    public char delimiter() {
        return delimiter;
    }
}

