package ru.yandex.parser.string;

import ru.yandex.collection.IntInterval;

public class StrictIntIntervalParser implements Parser<IntInterval> {
    public static final StrictIntIntervalParser INSTANCE =
        new StrictIntIntervalParser();

    protected StrictIntIntervalParser() {
    }

    @Override
    public IntInterval parse(final String value) {
        int idx = value.indexOf('-');
        if (idx == -1) {
            throw new IllegalArgumentException(
                "Interval expected to be in form <begin>-<end>, like 3-12");
        } else {
            return new IntInterval(
                Integer.parseInt(value.substring(0, idx).trim()),
                Integer.parseInt(value.substring(idx + 1).trim()));
        }
    }
}

