package ru.yandex.parser.string;

import ru.yandex.function.GenericUnaryOperator;

public class StringLengthValidator
    implements GenericUnaryOperator<String, Exception>
{
    private final int expectedLength;

    public StringLengthValidator(final int expectedLength) {
        this.expectedLength = expectedLength;
    }

    @Override
    public String apply(final String value) throws Exception {
        int length = value.length();
        if (length != expectedLength) {
            throw new IllegalArgumentException(
                "Expected string <" + value + "> length is " + expectedLength
                + ", but was " + length);
        }
        return value;
    }
}

