package ru.yandex.parser.string;

import java.text.ParseException;
import java.util.Iterator;
import java.util.Map;

import ru.yandex.collection.SingletonIterator;

public class StringMapValuesStorage implements ValuesStorage<ParseException> {
    private final Map<String, String> map;

    public StringMapValuesStorage(final Map<String, String> map) {
        this.map = map;
    }

    @Override
    public ParseException parameterNotSetException(final String name) {
        return new ParseException("Parameter " + name + " is not set", 0);
    }

    @Override
    public ParseException parseFailedException(
        final String name,
        final String value,
        final Throwable cause)
    {
        ParseException e = new ParseException(
            "Failed to parse parameter " + name
            + " with value '" + value + '\'',
            0);
        e.initCause(cause);
        return e;
    }

    @Override
    public String getOrNull(final String name) {
        return map.get(name);
    }

    @Override
    public String getLastOrNull(final String name) {
        return getOrNull(name);
    }

    @Override
    public Iterator<String> getAllOrNull(final String name) {
        String value = map.get(name);
        if (value == null) {
            return null;
        } else {
            return new SingletonIterator<>(value);
        }
    }

    @Override
    public String toString() {
        return map.toString();
    }
}

