package ru.yandex.parser.string;

public abstract class Validator<T> implements Parser<T> {
    private final Parser<? extends T> parser;

    protected Validator(final Parser<? extends T> parser) {
        this.parser = parser;
    }

    @Override
    public T parse(final String value) throws Exception {
        T result = parser.parse(value);
        validate(result);
        return result;
    }

    public abstract void validate(T value) throws Exception;
}

