package ru.yandex.util.string;

import ru.yandex.function.ByteArrayProcessor;

public enum HexStrings
    implements ByteArrayProcessor<char[], RuntimeException>
{
    UPPER {
        @Override
        protected char[] hex() {
            return UPPER_CHARS;
        }
    },
    LOWER {
        @Override
        protected char[] hex() {
            return LOWER_CHARS;
        }
    };

    public static final int SHIFT = 4;
    public static final int MASK = 0xf;

    private static final char[] UPPER_CHARS = {
        '0', '1', '2', '3', '4', '5', '6', '7',
        '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'
    };
    private static final char[] LOWER_CHARS = {
        '0', '1', '2', '3', '4', '5', '6', '7',
        '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'
    };

    protected abstract char[] hex();

    public char[] chars() {
        return hex();
    }

    @Override
    public char[] process(final byte[] buf, final int off, final int len) {
        char[] table = hex();
        char[] chars = new char[len << 1];
        int pos = 0;
        for (int i = 0; i < len; ++i) {
            byte b = buf[i + off];
            chars[pos++] = table[(b >>> SHIFT) & MASK];
            chars[pos++] = table[b & MASK];
        }
        return chars;
    }

    public String toString(final byte[] buf) {
        StringBuilder sb = new StringBuilder(buf.length << 1);
        toStringBuilder(sb, buf);
        return new String(sb);
    }

    public void toStringBuilder(final StringBuilder sb, final byte[] buf) {
        toStringBuilder(sb, buf, buf.length);
    }

    public void toStringBuilder(
        final StringBuilder sb,
        final byte[] buf,
        final int len)
    {
        char[] table = hex();
        for (int i = 0; i < len; ++i) {
            byte b = buf[i];
            sb.append(table[(b >>> SHIFT) & MASK]);
            sb.append(table[b & MASK]);
        }
    }
}

