package ru.yandex.util.string;

import java.io.IOException;
import java.io.Reader;

public class NormalizingReader extends Reader {
    private final NormalizingProcessor processor = new NormalizingProcessor();
    private final char[] buf = new char[
        NormalizingProcessor.NORMALIZATION_BLOCK_SIZE
        + NormalizingProcessor.MAX_LOOKAHEAD];
    private final Reader reader;
    private int len = 0;

    public NormalizingReader(final Reader reader) {
        this.reader = reader;
    }

    @Override
    public void close() throws IOException {
        len = 0;
        reader.close();
    }

    private void fillBuffer() throws IOException {
        while (len < buf.length) {
            int read = reader.read(buf, len, buf.length - len);
            if (read == -1) {
                break;
            }
            len += read;
        }
    }

    // CSOFF: FinalParameters
    @Override
    public int read(final char[] buf, final int off, final int len)
        throws IOException
    {
        if (len == 0) {
            return 0;
        }
        if (processor.isEmpty()) {
            fillBuffer();
            if (this.len < this.buf.length) {
                // EOF
                processor.process(this.buf, 0, this.len);
                this.len = 0;
            } else {
                int blockSize =
                    NormalizingProcessor.NORMALIZATION_BLOCK_SIZE + 1;
                for (int i = 0; i < NormalizingProcessor.MAX_LOOKAHEAD; ++i) {
                    if (NormalizingProcessor.good(
                            this.buf[
                                NormalizingProcessor.NORMALIZATION_BLOCK_SIZE
                                + i]))
                    {
                        blockSize =
                            NormalizingProcessor.NORMALIZATION_BLOCK_SIZE + i;
                        break;
                    }
                }
                processor.process(this.buf, 0, blockSize);
                for (int i = blockSize; i < this.buf.length; ++i) {
                    this.buf[i - blockSize] = this.buf[i];
                }
                this.len -= blockSize;
            }
        }
        int result;
        if (processor.isEmpty()) {
            result = -1;
        } else {
            result = processor.transferTo(buf, off, len);
        }
        return result;
    }
    // CSON: FinalParameters
}

