package ru.yandex.util.string;

public interface PrettyPrint {
    long THOUSAND = 1000L;
    long HUNDRED = 100L;
    long TEN = 10L;
    int SECONDS_BUFFER_SIZE = 14;
    int SHORT_STRING_LENGTH = 128;
    String LONG_STRING_SUFFIX = "...";

    static String millisToSeconds(final long millis) {
        StringBuilder sb = new StringBuilder(SECONDS_BUFFER_SIZE);
        millisToSeconds(sb, millis);
        return new String(sb);
    }

    // CSOFF: FinalParameters
    static void millisToSeconds(
        final StringBuilder sb,
        long millis)
    {
        if (millis < 0) {
            if (millis == Long.MIN_VALUE) {
                sb.append(millis);
                sb.insert(sb.length() - 2 - 1, '.');
                return;
            } else {
                sb.append('-');
                millis = -millis;
            }
        }
        if (millis < THOUSAND) {
            sb.append('0');
            sb.append('.');
            if (millis < HUNDRED) {
                sb.append('0');
                if (millis < TEN) {
                    sb.append('0');
                }
            }
            sb.append(millis);
        } else {
            sb.append(millis);
            sb.insert(sb.length() - 2 - 1, '.');
        }
    }
    // CSON: FinalParameters

    static String shortenString(final String str) {
        return shortenString(str, SHORT_STRING_LENGTH);
    }

    static String shortenString(final String str, final int maxLen) {
        String s = str;
        if (s.length() > maxLen + LONG_STRING_SUFFIX.length()) {
            StringBuilder sb =
                new StringBuilder(maxLen + LONG_STRING_SUFFIX.length());
            sb.append(s, 0, maxLen);
            sb.append(LONG_STRING_SUFFIX);
            s = new String(sb);
        }
        return s.trim().replace('\n', '#');
    }
}

