package ru.yandex.util.string;

import ru.yandex.function.CharArrayProcessor;

public enum UnhexStrings
    implements CharArrayProcessor<byte[], RuntimeException>
{
    INSTANCE;

    private static final int[] UNHEX = {
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        0, 1, 2, 3, 4, 5, 6, 7, 8, 9, -1, -1, -1, -1, -1, -1,
        -1, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        -1, 10, 11, 12, 13, 14, 15
    };

    private static final int[] HIGH = {
        0, 16, 32, 48, 64, 80, 96, 112, 128, 144, 160, 176, 192, 208, 224, 240
    };

    private static final int[] LOW = {
        0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15
    };

    public static byte unhex(final int high, final int low) {
        return (byte) (HIGH[UNHEX[high]] | LOW[UNHEX[low]]);
    }

    @Override
    public byte[] process(final char[] cbuf, final int off, final int len) {
        return unhex(cbuf, off, len);
    }

    public static byte[] unhex(final String s) {
        return unhex(s.toCharArray());
    }

    public static byte[] unhex(final char[] cbuf) {
        return unhex(cbuf, 0, cbuf.length);
    }

    public static byte[] unhex(
        final char[] cbuf,
        final int off,
        final int len)
    {
        if ((len & 1) == 1) {
            throw new IllegalArgumentException(
                "Odd string length: " + new String(cbuf, off, len));
        }
        int end = off + len;
        byte[] buf = new byte[len >> 1];
        for (int i = off, j = 0; i < end;) {
            buf[j++] = unhex(cbuf[i++], cbuf[i++]);
        }
        return buf;
    }

    public static void unhex(final String s, final byte[] buf) {
        int len = s.length();
        if ((len & 1) == 1) {
            throw new IllegalArgumentException("Odd string lenght: " + s);
        }
        if (buf.length < (len >> 1)) {
            throw new IllegalArgumentException("Output buffer to small: "
                + buf.length + ", required: " + (len >> 1));
        }
        for (int i = 0, j = 0; i < len;) {
            char high = s.charAt(i++);
            char low = s.charAt(i++);
            buf[j++] = unhex(high, low);
        }
    }
}

