package ru.yandex.util.system;

public class Rusage {
    static {
        System.loadLibrary("jni-rusage");
    }

    public static final Rusage NULL = new Rusage(0L, 0L, 0L, 0L, 0L);

    private final long maxRss;
    private final long currentRss;
    private final long majorPageFaults;
    private final long userTime;
    private final long systemTime;

    private Rusage(
        final long maxRss,
        final long currentRss,
        final long majorPageFaults,
        final long userTime,
        final long systemTime)
    {
        this.maxRss = maxRss;
        this.currentRss = currentRss;
        this.majorPageFaults = majorPageFaults;
        this.userTime = userTime;
        this.systemTime = systemTime;
    }

    // Max RSS in bytes
    public long maxRss() {
        return maxRss;
    }

    // Current RSS in bytes
    public long currentRss() {
        return currentRss;
    }

    // Major page faults count
    public long majorPageFaults() {
        return majorPageFaults;
    }

    // User time in microseconds
    public long userTime() {
        return userTime;
    }

    // Kernel time in microseconds
    public long systemTime() {
        return systemTime;
    }

    public static Rusage get() throws RusageException {
        try {
            long[] data = getNumbers();
            return new Rusage(data[0], data[1], data[2], data[3], data[4]);
        } catch (RuntimeException e) {
            throw new RusageException("Rusage failed", e);
        }
    }

    private static native long[] getNumbers();
}

