#include <mail/so/libs/jniwrapper_base/jniwrapper_base.h>

#include <util/datetime/base.h>
#include <util/system/rusage.h>

#include <jni.h>

static constexpr size_t ArraySize = 5;

extern "C" JNIEXPORT jlongArray JNICALL
Java_ru_yandex_util_system_Rusage_getNumbers(
    JNIEnv* env,
    jclass)
{
    try {
        size_t currentRss = TRusage::GetCurrentRSS();
        TRusage rusage{TRusage::Get()};
        jlongArray result = env->NewLongArray(ArraySize);
        if (result) {
            jlong array[ArraySize];
            array[0] = rusage.MaxRss;
            array[1] = currentRss;
            array[2] = rusage.MajorPageFaults;
            array[3] = rusage.Utime.MicroSeconds();
            array[4] = rusage.Stime.MicroSeconds();
            env->SetLongArrayRegion(result, 0, ArraySize, array);
            return result;
        } else {
            NJniWrapper::Throw(
                env,
                "java/lang/RuntimeException",
                "Array allocation failed");
        }
    } catch (...) {
        NJniWrapper::RethrowAsJavaException(env);
    }
    return 0;
}

