package ru.yandex.util.timesource;

import java.util.concurrent.locks.LockSupport;

public enum TimeSource {
    INSTANCE;

    @SuppressWarnings("ImmutableEnumChecker")
    private final Ticker ticker;

    TimeSource() {
        ticker = new Ticker();
        ticker.start();
    }

    public final long currentTimeMillis() {
        return ticker.millis;
    }

    public static class Ticker extends Thread {
        private volatile long millis = System.currentTimeMillis();

        Ticker() {
            super("Ticker");
            setDaemon(true);
        }

        @Override
        public void run() {
            while (true) {
                millis = System.currentTimeMillis();
                LockSupport.parkNanos(300000L);
            }
        }
    }
}
