package ru.yandex.url.processor;

import ru.yandex.parser.config.ConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractUrlProcessorConfigBuilder
    <T extends AbstractUrlProcessorConfigBuilder<T>>
    implements ConfigBuilder<T>, UrlProcessorConfig
{
    private String defaultScheme;
    private boolean requireSchemeForNonMailto;

    protected AbstractUrlProcessorConfigBuilder(final UrlProcessorConfig config) {
        defaultScheme(config.defaultScheme());
        requireSchemeForNonMailto(config.requireSchemeForNonMailto());
    }

    protected AbstractUrlProcessorConfigBuilder(
        final IniConfig config,
        final UrlProcessorConfig defaults)
        throws ConfigException
    {
        defaultScheme =
            DEFAULT_SCHEME.extract(config, defaults.defaultScheme());
        requireSchemeForNonMailto = REQUIRE_SCHEME_FOR_NON_MAILTO.extract(
            config,
            defaults.requireSchemeForNonMailto());
    }

    @Override
    public String defaultScheme() {
        return defaultScheme;
    }

    public T defaultScheme(final String defaultScheme) {
        this.defaultScheme = defaultScheme;
        return self();
    }

    @Override
    public boolean requireSchemeForNonMailto() {
        return requireSchemeForNonMailto;
    }

    public T requireSchemeForNonMailto(
        final boolean requireSchemeForNonMailto)
    {
        this.requireSchemeForNonMailto = requireSchemeForNonMailto;
        return self();
    }
}

