package ru.yandex.url.processor;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.ImmutableConfig;
import ru.yandex.util.string.StringUtils;

public class ImmutableUrlProcessorConfig
    implements ImmutableConfig, UrlProcessorConfig
{
    public static final ImmutableUrlProcessorConfig DEFAULT_CONFIG;

    static {
        try {
            DEFAULT_CONFIG = new ImmutableUrlProcessorConfig(
                UrlProcessorConfigDefaults.INSTANCE);
        } catch (ConfigException e) {
            throw new RuntimeException(e);
        }
    }

    private final String defaultScheme;
    private final boolean requireSchemeForNonMailto;
    private final String shortSchemePrefix;
    private final String fullSchemePrefix;

    public ImmutableUrlProcessorConfig(final UrlProcessorConfig config)
        throws ConfigException
    {
        defaultScheme = DEFAULT_SCHEME.validate(config.defaultScheme());
        requireSchemeForNonMailto = REQUIRE_SCHEME_FOR_NON_MAILTO.validate(
            config.requireSchemeForNonMailto());
        shortSchemePrefix = StringUtils.concat(defaultScheme, ':');
        fullSchemePrefix = StringUtils.concat(defaultScheme, "://");
    }

    @Override
    public String defaultScheme() {
        return defaultScheme;
    }

    @Override
    public boolean requireSchemeForNonMailto() {
        return requireSchemeForNonMailto;
    }

    public String shortSchemePrefix() {
        return shortSchemePrefix;
    }

    public String fullSchemePrefix() {
        return fullSchemePrefix;
    }
}

