package ru.yandex.url.processor;

import java.util.ArrayList;
import java.util.List;

import ru.yandex.function.CollectionConsumer;

public class StringUrlsExtractor {
    private static final char[] EMPTY_BUF = new char[0];

    private final List<UrlInfo> urlInfos = new ArrayList<>();
    private final CollectionConsumer<UrlInfo> consumer =
        new CollectionConsumer<>(urlInfos);
    private final UrlProcessor processor;
    private char[] buf = EMPTY_BUF;

    public StringUrlsExtractor() {
        this(ImmutableUrlProcessorConfig.DEFAULT_CONFIG);
    }

    public StringUrlsExtractor(
        final ImmutableUrlProcessorConfig config)
    {
        processor = new UrlProcessor(consumer, config);
    }

    public List<UrlInfo> extractUrls(final String str) {
        int len = str.length();
        if (len > buf.length) {
            buf = new char[Math.max(len, buf.length << 1)];
        }
        str.getChars(0, len, buf, 0);
        urlInfos.clear();
        processor.process(buf, 0, len);
        processor.process();
        return urlInfos;
    }
}

