package ru.yandex.url.processor;

import ru.yandex.function.AbstractStringBuilderable;
import ru.yandex.net.uri.fast.FastUri;

public class UrlInfo extends AbstractStringBuilderable {
    private static final int HALF_INT = 16;

    private final int start;
    private final int end;
    private final FastUri url;

    public UrlInfo(
        final int start,
        final int end,
        final FastUri url)
    {
        this.start = start;
        this.end = end;
        this.url = url;
    }

    public int start() {
        return start;
    }

    public int end() {
        return end;
    }

    public FastUri url() {
        return url;
    }

    @Override
    public int hashCode() {
        return url.hashCode() ^ start ^ (end << HALF_INT) ^ (end >> HALF_INT);
    }

    @Override
    public boolean equals(final Object o) {
        if (o instanceof UrlInfo) {
            UrlInfo other = (UrlInfo) o;
            return start == other.start
                && end == other.end
                && url.equals(other.url);
        }
        return false;
    }

    @Override
    public int expectedStringLength() {
        // separators + url + 2 relatively short ints
        return 4 + url.expectedStringLength() + 10;
    }

    @Override
    public void toStringBuilder(final StringBuilder sb) {
        sb.append('{');
        sb.append(start);
        sb.append(',');
        sb.append(end);
        sb.append(',');
        url.toStringBuilder(sb);
        sb.append('}');
    }
}

