package ru.yandex.url.processor;

import java.util.function.Consumer;

import ru.yandex.function.CharArrayVoidProcessor;
import ru.yandex.net.uri.fast.FastUri;

public abstract class UrlProcessorBase
    implements CharArrayVoidProcessor<RuntimeException>
{
    protected final UrlAccumulator accum;
    private final Consumer<UrlInfo> collector;
    private int globalOffset = 0;
    private int start;

    protected UrlProcessorBase(
        final Consumer<UrlInfo> collector,
        final ImmutableUrlProcessorConfig config)
    {
        this.collector = collector;
        accum = new UrlAccumulator(config);
    }

    public void reset() {
        accum.clear();
        globalOffset = 0;
    }

    protected void clear(final int pos) {
        accum.clear();
        start = pos + globalOffset;
    }

    protected void add(final boolean strictHostValidation) {
        FastUri uri = accum.build(strictHostValidation);
        if (uri != null) {
            collector.accept(new UrlInfo(start, start + accum.length(), uri));
            accum.clear();
        }
    }

    public void process() {
        process(null, 0, 0);
        reset();
    }

    @Override
    public void process(final char[] data, final int off, final int len) {
        processInternal(data, off, len);
        globalOffset += len;
    }

    protected abstract void processInternal(
        final char[] data,
        final int off,
        final int len);
}

