package ru.yandex.url.processor;

import ru.yandex.function.GenericFunction;
import ru.yandex.parser.config.ParameterConfig;
import ru.yandex.parser.string.BooleanParser;
import ru.yandex.parser.string.NonEmptyValidator;

public interface UrlProcessorConfig {
    ParameterConfig<String> DEFAULT_SCHEME = new ParameterConfig<>(
        "default-scheme",
        GenericFunction.identity(),
        NonEmptyValidator.INSTANCE);
    ParameterConfig<Boolean> REQUIRE_SCHEME_FOR_NON_MAILTO =
        new ParameterConfig<>(
            "require-scheme-for-non-mailto",
            BooleanParser.INSTANCE,
            GenericFunction.identity());

    String defaultScheme();

    boolean requireSchemeForNonMailto();
}
