package ru.yandex.url.processor;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public final class UrlProcessorConfigBuilder
    extends AbstractUrlProcessorConfigBuilder<UrlProcessorConfigBuilder>
{
    public UrlProcessorConfigBuilder() {
        super(UrlProcessorConfigDefaults.INSTANCE);
    }

    public UrlProcessorConfigBuilder(final UrlProcessorConfig config) {
        super(config);
    }

    public UrlProcessorConfigBuilder(final IniConfig config)
        throws ConfigException
    {
        super(config, UrlProcessorConfigDefaults.INSTANCE);
    }

    public UrlProcessorConfigBuilder(
        final IniConfig config,
        final UrlProcessorConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public UrlProcessorConfigBuilder self() {
        return this;
    }

    public ImmutableUrlProcessorConfig build() throws ConfigException {
        return new ImmutableUrlProcessorConfig(this);
    }
}

