package ru.yandex.parser.xpath;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class XPathParser {
    private XPathParser() {
    }

    private static final Pattern PATTERN = Pattern.compile(
        "(?:[.](?<name>([a-zA-Z_]([a-zA-Z0-9_]|[\\\\][.])*|[*])))|"
        + "(?:[\\[](?<index>0|[1-9][0-9]*)?[\\]])");

    public static <E extends Exception> void parse(
        final String str,
        final PathConsumer<E> consumer)
        throws E
    {
        Matcher matcher = PATTERN.matcher(str);
        if (matcher.find()) {
            int pos = 0;
            do {
                if (matcher.start() != pos) {
                    break;
                }
                int nextPos = matcher.end();
                String name = matcher.group("name");
                if (name == null) {
                    String index = matcher.group("index");
                    if (index == null) {
                        consumer.anyIndex();
                    } else {
                        int parsedIndex;
                        try {
                            parsedIndex = Integer.parseInt(index);
                        } catch (RuntimeException e) {
                            throw consumer.parseFailedException(
                                "Can't parse index <" + index + "> at pos "
                                + pos + " in string <" + str + '>',
                                e);
                        }
                        consumer.index(parsedIndex);
                    }
                } else {
                    consumer.name(name.replace("\\.", "."));
                }
                pos = nextPos;
            } while (matcher.find());
            if (pos < str.length()) {
                throw consumer.parseFailedException(
                    "Can't match suffix <" + str.substring(pos)
                    + "> in string <" + str + '>');
            }
        } else {
            throw consumer.parseFailedException(
                "No xpath components found in string <" + str + '>');
        }
    }
}

