include(yamail_find_dependencies)
function(find_vdirectnodejs_dependencies)

yamail_find_dependencies(VDIRECTNODEJS "MAILGETTER" "")
yamail_find_dependencies(SENDBERNARNODEJS "SENDBERNAR_CLIENT" "")
find_package(Boost REQUIRED)

find_program(
    NPM
        npm
    PATHS
        /opt/nodejs/8/bin
)

add_custom_command(
    COMMAND
        ${NPM} install chai@3.5.0 node-gyp@3.6.1 mocha@3.3.0 --prefix ${CMAKE_BINARY_DIR}
    OUTPUT
        ${CMAKE_BINARY_DIR}/node_modules/.bin/mocha
        ${CMAKE_BINARY_DIR}/node_modules/.bin/node-gyp
    WORKING_DIRECTORY
        ${CMAKE_SOURCE_DIR}
    COMMENT
        "${NPM} install chai@3.5.0 node-gyp@3.6.1 mocha@3.3.0 --prefix ${CMAKE_BINARY_DIR}"
)

add_custom_target(
    install_modules ALL
    DEPENDS
        ${CMAKE_BINARY_DIR}/node_modules/.bin/mocha
        ${CMAKE_BINARY_DIR}/node_modules/.bin/node-gyp
)

find_program(
    NODEJS
        node
    PATHS
        /opt/nodejs/8/bin
)

set(NODE_GYP
    ${CMAKE_BINARY_DIR}/node_modules/.bin/node-gyp
    CACHE INTERNAL ""
)

set(MOCHA
    ${CMAKE_BINARY_DIR}/node_modules/.bin/mocha
    CACHE INTERNAL ""
)

message(STATUS "nodejs: ${NODEJS}")
message(STATUS "node-gyn: ${NODE_GYP}")
message(STATUS "mocha: ${MOCHA}")

if ("${CMAKE_BUILD_TYPE}" STREQUAL "Debug")
    set (MODE "--debug" CACHE INTERNAL "")
    set (ADDON_DIR_NAME "Debug" CACHE INTERNAL "")
else()
    set (MODE "--release" CACHE INTERNAL "")
    set (ADDON_DIR_NAME "Release" CACHE INTERNAL "")
endif()

endfunction()
