#pragma once

#include <node.h>
#include <node_object_wrap.h>
#include <internal/hash_validator.h>


namespace nodejs {

inline std::string to_string(const v8::Local<v8::Value>& value) {
    v8::String::Utf8Value path(value->ToString());

    return *path;
}

class Vdirect: public node::ObjectWrap {
    Vdirect(v8::Isolate* isolate, const std::string& path);

    virtual ~Vdirect() { }

    static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
    static void createHashForUidLink(const v8::FunctionCallbackInfo<v8::Value>& args);
    static void validateHashForUidLink(const v8::FunctionCallbackInfo<v8::Value>& args);
    static void validateHashForSmsLink(const v8::FunctionCallbackInfo<v8::Value>& args);

    static v8::Persistent<v8::Function> constructor;

    vdirect::KeysStorage storage;

public:
    static void Init(v8::Local<v8::Object> exports);
};

}

