#include <internal/module.h>

#include <iostream>

using namespace v8;

namespace nodejs {

void Vdirect::Init(Local<Object> exports) {
    v8::Isolate* isolate = exports->GetIsolate();

    Local<FunctionTemplate> tpl = FunctionTemplate::New(isolate, New);
    tpl->SetClassName(String::NewFromUtf8(isolate, "Vdirect"));
    tpl->InstanceTemplate()->SetInternalFieldCount(1);

    NODE_SET_PROTOTYPE_METHOD(tpl, "createHashForUidLink", createHashForUidLink);
    NODE_SET_PROTOTYPE_METHOD(tpl, "validateHashForUidLink", validateHashForUidLink);
    NODE_SET_PROTOTYPE_METHOD(tpl, "validateHashForSmsLink", validateHashForSmsLink);

    constructor.Reset(isolate, tpl->GetFunction());
    exports->Set(String::NewFromUtf8(isolate, "Vdirect"),
                 tpl->GetFunction());
}

void InitAll(Local<Object> exports) {
  Vdirect::Init(exports);
}

NODE_MODULE(addon, InitAll)

}
