var modulesApiVersion = process.versions && process.versions.modules;
var libraryName = require('./package.json').name;

function version(version) {
    return __dirname + '/' + version + '/' + libraryName + '.node';
}

var module_path = version(modulesApiVersion);
var fs = require('fs');

if (!fs.existsSync(module_path)) {
    throw new Error('No binding for native extensions API v' + modulesApiVersion + "; wanted [" + module_path + "]");
}

module.exports = require(module_path);
