#include <internal/hash_validator.h>
#include <fstream>

vdirect::UidHashValidator getValidator(const vdirect::KeysStorage& keys, const std::string& uid) {
    return vdirect::UidHashValidator(keys, uid);
}

vdirect::SmsHashValidator getValidator(const vdirect::KeysStorage& keys, std::time_t linkTtl) {
    return vdirect::SmsHashValidator(keys, linkTtl);
}

vdirect::KeysStorage getKeysStorage(const std::string& path) {
    std::ifstream in(path);
    return vdirect::KeysStorage(in);
}
