#pragma once

#include <memory>

class TWebmailRecognizer {
public:
    int AnalyzeText(const char* doc, const unsigned len, int& encoding, int& language, const bool ishtml = true, const unsigned minLen = 8, const unsigned maxLen = 1024) const;
    int AnalyzeEncoding(const char* doc, const unsigned len, int& encoding) const;
    const char* AnalyzeTextName(const char* doc, const unsigned len, int& encoding, int& language, const bool ishtml = true, const unsigned minLen = 8, const unsigned maxLen = 1024) const;
    const char* AnalyzeEncodingName(const char* doc, const unsigned len, int& encoding) const;
    const char* IsoNameByLanguageCode(int lang) const;
        // doc - document begining
        // len - document length
        // encoding - resulting encoding
        // language - resulting language
        // ishtml - trigger for ht-markup stripper befor language recognition
        // minLen - min character count to be need in language recognition
        // maxLen - max character count to be used in language recognition
    TWebmailRecognizer(const char* languageDict = "/usr/share/recognizer/queryrec.dict"
                     , const char* languageWeights = "/usr/share/recognizer/queryrec.weights"
                     , const char* encodingDict = "/usr/share/recognizer/dict.dict");
        // languageDict - path to language dictionary file
        // languageWeights - path to language weights file
        // encodingDict - path to encoding dictionary file
    TWebmailRecognizer(TWebmailRecognizer&& other);
    ~TWebmailRecognizer();
private:
    class TImpl;
    std::unique_ptr<TImpl> Impl;
};
