#include <mail/webmail-recognizer/lib/webmail-recognizer.h>

#include <util/folder/dirut.h>
#include <util/generic/string.h>
#include <util/stream/file.h>
#include <util/stream/output.h>

int main (int argc, char** argv) {

    if (argc != 4) {
        Cout << "required arguments:"
             << "\n1 encodings dictionary path"
             << " 2 languages dictionary path"
             << " 3 languages weights path"
             << "\nfiles to process paths via stdin" << Endl;
        return 1;
    }

    if (!(NFs::Exists(argv[1]) && NFs::Exists(argv[2]) && NFs::Exists(argv[3]))) {
       Cout << "wrong paths" << Endl;
       return 1;
    }

    const TWebmailRecognizer r(argv[2], argv[3], argv[1]);
    TString p;
    while (Cin.ReadLine(p)) {
        int c = -1;
        int l = -1;
        TString t = TUnbufferedFileInput(p).ReadAll();

        Cout << p << ": " << r.AnalyzeText(t.data(), t.size(), c, l, true)
             << "; c: " << c
             << "; l: " << l << Endl;
    }
}
