#pragma once

#include <memory>

#include <pgg/profiling.h>
#include <pgg/logging.h>
#include <pgg/logdog.h>
#include <logdog/attribute.h>
#include <boost/smart_ptr/make_shared.hpp>

namespace commondb {

namespace attr {
LOGDOG_DEFINE_ATTRIBUTE(std::string, settings)
LOGDOG_DEFINE_ATTRIBUTE(std::string, pg_settings)
LOGDOG_DEFINE_ATTRIBUTE(std::size_t, password_length)
}

void hidePassword(std::string& connString, std::string_view password);
pgg::profiling::LogPtr pggProfiler(const std::string& uid, const std::string& reqId, const std::string& serivce);

template<class Logger>
pgg::logging::LogPtr pggLogger(std::string_view password, Logger l) {
    return std::make_shared<pgg::logging::TypedLog<Logger>>(
        std::move(l),
        [password](const pgg::logging::ConnectionInfo& info) {
            pgg::logging::ConnectionInfo ret = info;
            hidePassword(ret.t, password);
            return ret;
        }
    );
}

}
