#pragma once

#include <pgg/chrono.h>
#include <yplatform/ptree.h>


namespace commondb {

struct PgSettings {
    bool log_pa = false;
    std::size_t max_connections = 0;
    std::size_t max_total_pools_capacity = 0;
    pgg::Milliseconds queue_timeout_ms;
    pgg::Milliseconds connect_timeout_ms;
    pgg::Milliseconds query_timeout_ms;
    std::string query_conf;
    std::string connection_string;
    std::string user;
    std::optional<std::string> password_file;
    bool async_resolve = false;
    bool ipv6_only = false;
    pgg::Seconds dns_cache_ttl_sec = pgg::Seconds::zero();
};

}
