#pragma once

#include <mail/webmail/commondb/include/settings.h>
#include <yamail/data/deserialization/ptree.h>
#include <yamail/data/serialization/json_writer.h>
#include <yamail/data/serialization/ptree.h>
#include <yamail/data/reflection.h>


#ifndef MEMBER_DURATION
#define MEMBER_DURATION(duration, name) (name, std::int64_t, std::int64_t, (obj.name.count()), (obj.name = duration(val)))
#else
#error "duplicate MEMBER_DURATION definition"
#endif

#ifndef MEMBER_PGG_MILLISECONDS
#define MEMBER_PGG_MILLISECONDS(name) MEMBER_DURATION(pgg::Milliseconds, name)
#else
#error "duplicate MEMBER_PGG_MILLISECONDS definition"
#endif

#ifndef MEMBER_PGG_SECONDS
#define MEMBER_PGG_SECONDS(name) MEMBER_DURATION(pgg::Seconds, name)
#else
#error "duplicate MEMBER_PGG_SECONDS definition"
#endif

YREFLECTION_ADAPT_ADT(commondb::PgSettings,
    YREFLECTION_MEMBER(bool, log_pa)
    YREFLECTION_MEMBER(size_t, max_connections)
    YREFLECTION_MEMBER(size_t, max_total_pools_capacity)
    MEMBER_PGG_MILLISECONDS(queue_timeout_ms)
    MEMBER_PGG_MILLISECONDS(connect_timeout_ms)
    MEMBER_PGG_MILLISECONDS(query_timeout_ms)
    YREFLECTION_MEMBER(std::string, query_conf)
    YREFLECTION_MEMBER(std::string, connection_string)
    YREFLECTION_MEMBER(std::string, user)
    YREFLECTION_MEMBER(std::optional<std::string>, password_file)
    YREFLECTION_MEMBER(bool, async_resolve)
    YREFLECTION_MEMBER(bool, ipv6_only)
    MEMBER_PGG_SECONDS(dns_cache_ttl_sec)
)

#undef MEMBER_DURATION
#undef MEMBER_PGG_MILLISECONDS
#undef MEMBER_PGG_SECONDS

namespace commondb {
using boost::fusion::operators::operator==;

PgSettings readPgSettings(const yplatform::ptree& tree);

}
