#include <mail/webmail/commondb/include/logger.h>
#include <boost/algorithm/string/finder.hpp>
#include <boost/algorithm/string/find.hpp>
#include <pgg/logdog.h>
#include <pa/async.h>


namespace commondb {

void hidePassword(std::string& connString, std::string_view password) {
    if (auto r = boost::algorithm::find(connString, boost::algorithm::first_finder(password)); r) {
        std::transform(r.begin(), r.end(), r.begin(), [](const auto) { return '*'; });
    }
}

struct PaProfiler: public pgg::profiling::Log {
    std::string additionalInfoStart;
    std::string additionalInfoEnd;
    std::string serivce;

    PaProfiler(const std::string& uid, const std::string& reqId, const std::string& name)
        : additionalInfoStart(uid + ",")
        , additionalInfoEnd(std::string(",") + reqId)
        , serivce(name)
    { }

    void write(const std::string& operation, const std::string& info,
               pgg::Duration duration) const override {
        pa::async_profiler::add(
            pa::postgresql, serivce, operation,
            additionalInfoStart + info + additionalInfoEnd,
            static_cast<uint32_t>(pgg::Milliseconds(duration).count())
        );
    }
};

pgg::profiling::LogPtr pggProfiler(const std::string& uid, const std::string& reqId, const std::string& serivce) {
    return boost::make_shared<PaProfiler>(uid, reqId, serivce);
}

}
