#include <mail/webmail/commondb/include/settings.h>
#include <mail/webmail/commondb/include/settings_reflection.h>
#include <boost/algorithm/string/predicate.hpp>
#include <yamail/data/serialization/json_writer.h>
#include <yamail/data/deserialization/ptree.h>


namespace commondb {

PgSettings readPgSettings(const yplatform::ptree& tree) {
    PgSettings pg = yamail::data::deserialization::fromPtree<PgSettings>(tree);

    if (boost::algorithm::icontains(pg.connection_string, "target_session_attrs")) {
        throw std::runtime_error("cannot start with 'target_session_attrs' in connection string");
    }

    return pg;
}

}
