#pragma once

#include <mail/webmail/corgi/include/parse.h>
#include <mail/http_getter/client/include/module.h>
#include <mail/webmail/http_api_helpers/include/context.h>
#include <mail/webmail/http_api_helpers/include/handler_helpers.h>


namespace corgi {

template<class F>
auto userHandler(http_getter::TypedModulePtr getter, F f) {
    return [=] (ymod_webserver::response_ptr s, boost::asio::yield_context yield) {
        http_api::Context ctx {s->request()};
        SettingParams params = parseSettingParams(ctx);

        auto log = http_getter::withLog(getter->httpLogger(std::to_string(params.uid.t), params.requestId));
        auto httpClient = getter->create(*s->request(), log);

        return f(std::move(params), std::move(httpClient), std::move(yield));
    };
}

template<class F>
auto organizationHandler(http_getter::TypedModulePtr getter, F f) {
    return [=] (ymod_webserver::response_ptr s, boost::asio::yield_context yield) {
        http_api::Context ctx {s->request()};
        OrganizationParams params = parseOrganizationParams(ctx);

        auto log = http_getter::withLog(getter->httpLogger("", params.requestId));
        auto httpClient = getter->create(*s->request(), log);

        return f(std::move(params), std::move(httpClient), std::move(yield));
    };
}

}
