#pragma once

#include <yamail/data/deserialization/urlencoded_reader.h>
#include <mail/webmail/http_api_helpers/include/context.h>


namespace corgi {

template<class T>
inline auto wrap(T&& fn) {
    try {
        fn();
    } catch (const yamail::data::deserialization::urlencoded::ReaderException& ex) {
        http_api::Context::throwMissingParamException(ex.what());
    }
}

template<class Type>
Type parse(const http_api::Context& ctx) {
    Type variableToFill;
    const auto extractOneArg   = [&] (auto&& name) { return ctx.optionalArg(name);  };
    const auto extractManyArgs = [&] (auto&& name) { return ctx.optionalArgs(name); };

    wrap([&] () {
        yamail::data::deserialization::fromUrlencoded(variableToFill, extractOneArg, extractManyArgs);
    });

    return variableToFill;
}

}
