#pragma once

#include <mail/webmail/corgi/include/types.h>
#include <mail/webmail/corgi/include/resolve/directory.h>
#include <mail/http_getter/client/include/typed_client.h>


namespace corgi {

class OrganizationResolver {
    const ResolverConfig& config;
    http_getter::TypedClientPtr client;
    CommonParams common;

    DirectoryUsers resolveOrganizationAndFilterPddUsers(boost::asio::yield_context yield) const;

public:

    OrganizationResolver(const ResolverConfig& cfg, http_getter::TypedClientPtr clt, const CommonParams& c)
        : config(cfg)
        , client(std::move(clt))
        , common(c)
    { }

    Uids resolveUsers(const ResolveUsers& resolve, boost::asio::yield_context yield) const;
};

class OrganizationResolverWithoutAdminUid {
    const ResolverConfig& config;
    http_getter::TypedClientPtr client;
    OrganizationParams common;

    DirectoryUsers resolveOrganizationAndFilterPddUsers(boost::asio::yield_context yield) const;

public:

    OrganizationResolverWithoutAdminUid(const ResolverConfig& cfg, http_getter::TypedClientPtr clt, const OrganizationParams& c)
        : config(cfg)
        , client(std::move(clt))
        , common(c)
    { }

    Uids resolveUsers(const ResolveUsers& resolve, boost::asio::yield_context yield) const;
};

}
