#pragma once

#include <mail/webmail/corgi/include/types.h>
#include <mail/webmail/corgi/include/resolve/config.h>
#include <yamail/expected.h>

namespace corgi {

struct DirectoryUser {
    Uid uid;
    bool admin = false;
    std::optional<DepartmentId> departmentId;
    GroupsSet groups;

    auto operator<=>(const DirectoryUser&) const = default;
};
using DirectoryUsers = std::vector<DirectoryUser>;
using UidToDirectoryUserMap = std::map<Uid, DirectoryUser>;
using DepartmentsTree = std::map<DepartmentId, Departments>;


yamail::expected<bool> isAdmin(const CommonParams& common,
                               const http_getter::TypedClient& client,
                               const ResolverConfig& config,
                               boost::asio::yield_context yield);

yamail::expected<UidToDirectoryUserMap> resolveOrgId(OrgId orgId,
                                                     const http_getter::TypedClient& client,
                                                     const ResolverConfig& config,
                                                     boost::asio::yield_context yield);

yamail::expected<DepartmentsTree> resolveDepartmentsTree(OrgId orgId,
                                                         const http_getter::TypedClient& client,
                                                         const ResolverConfig& config,
                                                         boost::asio::yield_context yield);

}
