#pragma once

#include <mail/webmail/corgi/include/types_error.h>
#include <mail_errors/error_code.h>
#include <boost/coroutine/exceptions.hpp>
#include <yamail/expected.h>


namespace corgi {

template<class Result, class Fn>
void trycatch(Result& result, Fn fn) {
    try {
        fn();
    } catch (const boost::coroutines::detail::forced_unwind&) {
        throw;
    } catch (const boost::system::system_error& e) {
        result = yamail::make_unexpected(mail_errors::error_code(e.code(), e.what()));
    } catch (const std::exception& e) {
        result = make_unexpected(corgi::UnexpectedError::exception, e.what());
    }
}

}
