#pragma once

#include <mail/webmail/corgi/include/types.h>
#include <ymod_webserver/codes.h>

namespace corgi {

constexpr int ENUM_ERROR_STARTING_VALUE = 1;

enum class UnexpectedError {
    exception = ENUM_ERROR_STARTING_VALUE,
    condition,
};

enum class AccessError {
    accessDenied = ENUM_ERROR_STARTING_VALUE,
};

enum class RemoteServiceError {
    blackbox = ENUM_ERROR_STARTING_VALUE,
    directory,
};

enum class DbError {
    permanentFail = ENUM_ERROR_STARTING_VALUE,
};

enum class ResolveOrganizationError {
    noPddUidsInRequest = ENUM_ERROR_STARTING_VALUE,
    includeExcludeIntersection,
};

bool errorCodeToResponseCode(const mail_errors::error_code& ec, ymod_webserver::codes::code& code);


struct UnexpectedCategory: public mail_errors::error_code::error_category {
    const char* name() const noexcept override {
        return "unexpected";
    }

    std::string message(int v) const override;
};
const UnexpectedCategory& getUnexpectedCategory();
mail_errors::error_code::base_type make_error_code(UnexpectedError e);
mail_errors::error_code make_error(UnexpectedError e, std::string what="");
inline auto make_unexpected(UnexpectedError e, std::string what="") {
    return yamail::make_unexpected(make_error(e, std::move(what)));
}


struct AccessCategory: public mail_errors::error_code::error_category {
    const char* name() const noexcept override {
        return "access";
    }

    std::string message(int v) const override;
};
const AccessCategory& getAccessCategory();
mail_errors::error_code::base_type make_error_code(AccessError e);
mail_errors::error_code make_error(AccessError e, std::string what="");
inline auto make_unexpected(AccessError e, std::string what="") {
    return yamail::make_unexpected(make_error(e, std::move(what)));
}


struct RemoteServiceCategory: public mail_errors::error_code::error_category {
    const char* name() const noexcept override {
        return "remote";
    }

    std::string message(int v) const override;
};
const RemoteServiceCategory& getRemoteServiceCategory();
mail_errors::error_code::base_type make_error_code(RemoteServiceError e);
mail_errors::error_code make_error(RemoteServiceError e, std::string what="");
inline auto make_unexpected(RemoteServiceError e, std::string what="") {
    return yamail::make_unexpected(make_error(e, std::move(what)));
}


struct DbCategory: public mail_errors::error_code::error_category {
    const char* name() const noexcept override {
        return "database";
    }

    std::string message(int v) const override;
};
const DbCategory& getDbCategory();
mail_errors::error_code::base_type make_error_code(DbError e);
mail_errors::error_code make_error(DbError e, std::string what);


struct ResolveOrganizationErrorCategory: public mail_errors::error_code::error_category {
    const char* name() const noexcept override {
        return "create search";
    }

    std::string message(int v) const override;
};
const ResolveOrganizationErrorCategory& getResolveOrganizationErrorCategory();
mail_errors::error_code::base_type make_error_code(ResolveOrganizationError e);
mail_errors::error_code make_error(ResolveOrganizationError e, std::string what="");
inline auto make_unexpected(ResolveOrganizationError e, std::string what="") {
    return yamail::make_unexpected(make_error(e, std::move(what)));
}

}


namespace boost::system {
template <>
struct is_error_code_enum<corgi::UnexpectedError> : std::true_type { };
template <>
struct is_error_code_enum<corgi::AccessError> : std::true_type { };
template <>
struct is_error_code_enum<corgi::RemoteServiceError> : std::true_type { };
template <>
struct is_error_code_enum<corgi::DbError> : std::true_type { };
template <>
struct is_error_code_enum<corgi::ResolveOrganizationError> : std::true_type { };
}
