#pragma once

#include <mail/webmail/corgi/include/types.h>
#include <boost/fusion/include/adapt_struct.hpp>
#include <yamail/data/reflection.h>


YREFLECTION_ADAPT_ADT(corgi::CommonParams,
    YREFLECTION_MEMBER_RENAMED(corgi::Uid, admin_uid, adminUid)
    YREFLECTION_MEMBER_RENAMED(corgi::OrgId, org_id, orgId)
    YREFLECTION_MEMBER_RENAMED(corgi::RequestId, request_id, requestId)
)

YREFLECTION_ADAPT_ADT(corgi::SettingParams,
    YREFLECTION_MEMBER(corgi::Uid, uid)
    YREFLECTION_MEMBER_RENAMED(corgi::RequestId, request_id, requestId)
)

YREFLECTION_ADAPT_ADT(corgi::OrganizationParams,
    YREFLECTION_MEMBER_RENAMED(corgi::OrgId, org_id, orgId)
    YREFLECTION_MEMBER_RENAMED(corgi::RequestId, request_id, requestId)
)

YREFLECTION_ADAPT_ENUM(corgi::OrganizationState,
    active,
    disabled,
    frozen
)

YREFLECTION_ADAPT_ADT(corgi::PageParams,
    YREFLECTION_PROPERTY(unsigned, count)
    YREFLECTION_PROPERTY(std::optional<std::string>, first)
)

