#include <mail/webmail/corgi/include/parse.h>
#include <mail/webmail/corgi/include/types_reflection.h>
#include <mail/webmail/corgi/include/parse_urlencoded.h>
#include <yamail/data/reflection.h>


namespace corgi {

struct CommonParamsArgs {
    Uid& adminUid;
    OrgId& orgId;
};

struct CommonParamsHeaders {
    std::optional<RequestId> requestId;
};

CommonParams parseCommonParams(const http_api::Context& ctx) {
    CommonParams p;
    CommonParamsArgs a { .adminUid=p.adminUid, .orgId=p.orgId };
    CommonParamsHeaders h;
    namespace ydd = yamail::data::deserialization;

    wrap([&] () {
        ydd::fromUrlencoded(a, [&] (auto&& name) { return ctx.optionalArg(name);    } );
        ydd::fromUrlencoded(h, [&] (auto&& name) { return ctx.optionalHeader(name); } );
    });

    p.requestId = h.requestId.value_or("");

    return p;
}

SettingParams parseSettingParams(const http_api::Context& ctx) {
    return SettingParams {
        .uid=makeUid(ctx.arg("uid")),
        .requestId=ctx.optionalHeader("x-request-id").value_or("")
    };
}

OrganizationParams parseOrganizationParams(const http_api::Context& ctx) {
    return OrganizationParams {
        .orgId=makeOrgId(ctx.arg("org_id")),
        .requestId=ctx.optionalHeader("x-request-id").value_or("")
    };
}

PageParams parsePageParams(const http_api::Context& ctx) {
    return parse<PageParams>(ctx);
}

}

YREFLECTION_ADAPT_ADT(corgi::CommonParamsHeaders,
    YREFLECTION_MEMBER_RENAMED(std::optional<std::string>, X-Request-Id, requestId)
)

YREFLECTION_ADAPT_ADT(corgi::CommonParamsArgs,
    YREFLECTION_MEMBER_RENAMED(corgi::Uid, admin_uid, adminUid)
    YREFLECTION_MEMBER_RENAMED(corgi::OrgId, org_id, orgId)
)
