#include <mail/webmail/corgi/include/resolve/auth.h>
#include <mail/webmail/corgi/include/resolve/blackbox.h>
#include <mail/webmail/corgi/include/resolve/directory.h>
#include <mail/webmail/corgi/include/resolve/include_exclude.h>
#include <mail/webmail/corgi/include/types_error.h>
#include <boost/range/adaptor/filtered.hpp>


namespace corgi {

UidToDirectoryUserMap resolve(OrgId orgId, Uid adminUid,
                              const http_getter::TypedClient& client,
                              const ResolverConfig& config,
                              boost::asio::yield_context yield) {
    UidToDirectoryUserMap org = resolveOrgId(orgId, client, config, yield).value_or_throw();

    if (const auto it = org.find(adminUid); it == org.end() || !it->second.admin) {
        throw mail_errors::system_error(make_error(corgi::AccessError::accessDenied, "is not admin"));
    }

    return org;
}

UidToDirectoryUserMap resolve(OrgId orgId,
                              const http_getter::TypedClient& client,
                              const ResolverConfig& config,
                              boost::asio::yield_context yield) {
    return resolveOrgId(orgId, client, config, yield).value_or_throw();
}

DirectoryUsers OrganizationResolver::resolveOrganizationAndFilterPddUsers(boost::asio::yield_context yield) const {
    UidToDirectoryUserMap org = resolve(common.orgId, common.adminUid, *client, config, yield);

    Uids uidsFromDirectory;
    boost::copy(org | boost::adaptors::map_keys, std::back_inserter(uidsFromDirectory));

    const UidsSet pdd = pddUids(uidsFromDirectory, *client, config, yield).value_or_throw();

    DirectoryUsers filtered;
    boost::copy(
        org
        | boost::adaptors::map_values
        | boost::adaptors::filtered([&] (auto&& u) { return pdd.contains(u.uid); })
        , std::back_inserter(filtered)
    );

    return filtered;
}

Uids OrganizationResolver::resolveUsers(const ResolveUsers& params, boost::asio::yield_context yield) const {
    DirectoryUsers users = resolveOrganizationAndFilterPddUsers(yield);
    DepartmentsTree tree = resolveDepartmentsTree(common.orgId, *client, config, yield).value_or_throw();

    return IncludeAndExcludeByUidAndDepartment(params, tree).filter(std::move(users));
}

DirectoryUsers OrganizationResolverWithoutAdminUid::resolveOrganizationAndFilterPddUsers(boost::asio::yield_context yield) const {
    UidToDirectoryUserMap org = resolve(common.orgId, *client, config, yield);

    Uids uidsFromDirectory;
    boost::copy(org | boost::adaptors::map_keys, std::back_inserter(uidsFromDirectory));

    const UidsSet pdd = pddUids(uidsFromDirectory, *client, config, yield).value_or_throw();

    DirectoryUsers filtered;
    boost::copy(
        org
        | boost::adaptors::map_values
        | boost::adaptors::filtered([&] (auto&& u) { return pdd.contains(u.uid); })
        , std::back_inserter(filtered)
    );

    return filtered;
}

Uids OrganizationResolverWithoutAdminUid::resolveUsers(const ResolveUsers& params, boost::asio::yield_context yield) const {
    DirectoryUsers users = resolveOrganizationAndFilterPddUsers(yield);
    DepartmentsTree tree = resolveDepartmentsTree(common.orgId, *client, config, yield).value_or_throw();

    return IncludeAndExcludeByUidAndDepartment(params, tree).filter(std::move(users));
}

}
