#include <mail/webmail/corgi/include/resolve/config.h>
#include <mail/http_getter/client/include/endpoint_reflection.h>
#include <yamail/data/deserialization/ptree_reader.h>


namespace corgi {

ResolverConfig fromPtree(const yplatform::ptree& cfg) {
    namespace ydd = yamail::data::deserialization;
    using namespace http_getter;
    return ResolverConfig {
        .blackbox=ydd::fromPtree<TypedEndpoint>(cfg.get_child("blackbox")),
        .directoryUsers=ydd::fromPtree<TypedEndpoint>(cfg.get_child("directory.users")),
        .directorySingleUser=ydd::fromPtree<TypedEndpoint>(cfg.get_child("directory.single_user")),
        .directoryDepartments=ydd::fromPtree<TypedEndpoint>(cfg.get_child("directory.departments")),
    };
}

}
