#include <mail/webmail/corgi/include/types_error.h>
#include <mail/webmail/corgi/include/types.h>


namespace corgi {

std::string ResolveOrganizationErrorCategory::message(int v) const {
    switch (ResolveOrganizationError(v)) {
        case ResolveOrganizationError::noPddUidsInRequest:
            return "there are no ppd uids";
        case ResolveOrganizationError::includeExcludeIntersection:
            return "intersection";
    }
    return "unknown enum code";
}

const ResolveOrganizationErrorCategory& getResolveOrganizationErrorCategory() {
    static ResolveOrganizationErrorCategory category;
    return category;
}

mail_errors::error_code::base_type make_error_code(ResolveOrganizationError e) {
    return mail_errors::error_code::base_type(static_cast<int>(e), getResolveOrganizationErrorCategory());
}

mail_errors::error_code make_error(ResolveOrganizationError e, std::string what) {
    return mail_errors::error_code(e, std::move(what));
}


std::string UnexpectedCategory::message(int v) const {
    switch(UnexpectedError(v)) {
        case UnexpectedError::exception:
            return "unexpected exception";
        case UnexpectedError::condition:
            return "unexpected condition";
    }
    return "unknown enum code";
}

const UnexpectedCategory& getUnexpectedCategory() {
    static UnexpectedCategory instance;
    return instance;
}

mail_errors::error_code::base_type make_error_code(UnexpectedError e) {
    return mail_errors::error_code::base_type(static_cast<int>(e), getUnexpectedCategory());
}

mail_errors::error_code make_error(UnexpectedError e, std::string what) {
    return mail_errors::error_code(e, std::move(what));
}


std::string AccessCategory::message(int v) const {
    switch(AccessError(v)) {
        case AccessError::accessDenied:
            return "access denied";
    }
    return "unknown enum code";
}

const AccessCategory& getAccessCategory() {
    static AccessCategory instance;
    return instance;
}

mail_errors::error_code::base_type make_error_code(AccessError e) {
    return mail_errors::error_code::base_type(static_cast<int>(e), getAccessCategory());
}

mail_errors::error_code make_error(AccessError e, std::string what) {
    return mail_errors::error_code(e, std::move(what));
}


std::string RemoteServiceCategory::message(int v) const {
    switch (RemoteServiceError(v)) {
        case RemoteServiceError::blackbox:
            return "blackbox";
        case RemoteServiceError::directory:
            return "directory";
    }
    return "unknown enum code";
}

const RemoteServiceCategory& getRemoteServiceCategory() {
    static RemoteServiceCategory category;
    return category;
}

mail_errors::error_code::base_type make_error_code(RemoteServiceError e) {
    return mail_errors::error_code::base_type(static_cast<int>(e), getRemoteServiceCategory());
}

mail_errors::error_code make_error(RemoteServiceError e, std::string what) {
    return mail_errors::error_code(e, std::move(what));
}


std::string DbCategory::message(int v) const {
    switch(DbError(v)) {
        case DbError::permanentFail:
            return "permanent fail";
    }
    return "unknown error";
}

const DbCategory& getDbCategory() {
    static DbCategory instance;
    return instance;
}

mail_errors::error_code::base_type make_error_code(DbError e) {
    return mail_errors::error_code::base_type(static_cast<int>(e), getDbCategory());
}

mail_errors::error_code make_error(DbError e, std::string what) {
    return mail_errors::error_code(e, std::move(what));
}

bool errorCodeToResponseCode(const mail_errors::error_code& ec, ymod_webserver::codes::code& code) {
    if (ec.category() == corgi::getUnexpectedCategory()) {
        switch(corgi::UnexpectedError(ec.value())) {
            case corgi::UnexpectedError::exception:
            case corgi::UnexpectedError::condition:
                code = ymod_webserver::codes::internal_server_error; break;
        }
        return true;
    } else if (ec.category() == corgi::getAccessCategory()) {
        switch(corgi::AccessError(ec.value())) {
            case corgi::AccessError::accessDenied:
                code = ymod_webserver::codes::bad_request; break;
        }
        return true;
    } else if (ec.category() == corgi::getRemoteServiceCategory()) {
        switch (corgi::RemoteServiceError(ec.value())) {
            case corgi::RemoteServiceError::directory:
            case corgi::RemoteServiceError::blackbox:
                code = ymod_webserver::codes::internal_server_error; break;
        }
        return true;
    } else if (ec.category() == corgi::getResolveOrganizationErrorCategory()) {
        switch(corgi::ResolveOrganizationError(ec.value())) {
            case corgi::ResolveOrganizationError::noPddUidsInRequest:
            case corgi::ResolveOrganizationError::includeExcludeIntersection:
                code = ymod_webserver::codes::bad_request; break;
        }
        return true;
    } else if (ec.category() == corgi::getDbCategory()) {
        switch (corgi::DbError(ec.value())) {
            case corgi::DbError::permanentFail:
                code = ymod_webserver::codes::bad_request; break;
        }
        return true;
    } else {
        return false;
    }
}

}
